﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierContactCommandValidator : AbstractValidator<AddSupplierContactCommand>
{
    public AddSupplierContactCommandValidator()
    {
        RuleFor(c => c.SupplierId)
            .NotEmpty()
            .WithMessage("SupplierId is required and cannot be empty.");
        RuleFor(c => c.Name)
            .NotEmpty()
            .WithMessage("ContactName is required and cannot be empty.");
        RuleFor(c => c.Email)
            .NotEmpty()
            .EmailAddress()
            .WithMessage("ContactEmail is required and must be a valid email address.");
        RuleFor(c => c.Phone)
            .NotEmpty()
            .WithMessage("ContactPhone is required and cannot be empty.");
        RuleFor(c => c.Position)
            .NotEmpty()
            .WithMessage("ContactPosition is required and cannot be empty.");
    }
}
