﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class DeleteSupplierContactCommandHandler(
    ISupplierContactRepository supplierContactRepository,
    ILogger<DeleteSupplierContactCommandHandler> logger,
    IUnitOfWork<QMSDbContext> unitOfWork) : IRequestHandler<DeleteSupplierContactCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteSupplierContactCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var supplierContact = await supplierContactRepository.FindAsync(request.Id);
            if (supplierContact == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            supplierContactRepository.Remove(supplierContact);
            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith204();
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting supplierContact");
            return ServiceResponse<bool>.Return500("Error while deleting supplierContact");
        }
    }
}
