﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierContactCommandHandler(
    ISupplierContactRepository supplierContactRepository,
    ILogger<GetSupplierContactCommandHandler> _logger,
    IMapper mapper) : IRequestHandler<GetSupplierContactCommand, ServiceResponse<List<SupplierContactDto>>>
{
    public async Task<ServiceResponse<List<SupplierContactDto>>> Handle(GetSupplierContactCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await supplierContactRepository
                .All
                .Include(c => c.Supplier)
                .Where(c => c.SupplierId == request.Id)
                .ToListAsync();
            var entitiesDto = mapper.Map<List<SupplierContactDto>>(entities);
            return ServiceResponse<List<SupplierContactDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting SupplierContact");
            return ServiceResponse<List<SupplierContactDto>>.Return500("Error while getting SupplierContact");
        }
    }
}
