﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierPerformanceCommandValidator : AbstractValidator<AddSupplierPerformanceCommand>
{
    public AddSupplierPerformanceCommandValidator()
    {
        RuleFor(c => c.SupplierId)
            .NotEmpty()
            .WithMessage("SupplierId is required and cannot be empty.");
        RuleFor(c => c.EvaluatedById)
            .NotEmpty()
            .WithMessage("EvaluatedById is required and cannot be empty.");
        RuleFor(c => c.EvaluationDate)
            .NotEmpty()
            .WithMessage("EvaluationDate is required and cannot be empty.");
        RuleFor(c => c.Criteria)
            .NotEmpty()
            .WithMessage("Criteria is required and cannot be empty.");
        RuleFor(c => c.Score)
            .InclusiveBetween(0, 100)
            .WithMessage("Score must be between 0 and 100.");
        RuleFor(c => c.Remarks)
            .NotEmpty()
            .WithMessage("Remarks is required and cannot be empty.");
    }
}
