﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierPerformanceCommandHandler(
    ISupplierPerformanceRepository supplierPerformanceRepository,
    ILogger<GetSupplierContactCommandHandler> _logger,
    IMapper mapper) : IRequestHandler<GetSupplierPerformanceCommand, ServiceResponse<List<SupplierPerformanceDto>>>
{
    public async Task<ServiceResponse<List<SupplierPerformanceDto>>> Handle(GetSupplierPerformanceCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await supplierPerformanceRepository
                .All
                .Include(c => c.EvaluatedBy)
                .Where(c => c.SupplierId == request.Id)
                .ToListAsync();
            var entitiesDto = mapper.Map<List<SupplierPerformanceDto>>(entities);
            return ServiceResponse<List<SupplierPerformanceDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting SupplierPerformance");
            return ServiceResponse<List<SupplierPerformanceDto>>.Return500("Error while getting SupplierPerformance");
        }
    }
}
