﻿using System;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;

namespace QualityManagement.MediatR;
public class AddSupplierQualificationCommand : IRequest<ServiceResponse<SupplierQualificationDto>>
{
    public Guid SupplierId { get; set; }
    public DateTime QualificationDate { get; set; } // Date when the qualification was obtained
    public Guid QualifiedById { get; set; }
    public string Criteria { get; set; } //	Summary of evaluation criteria
    public string Result { get; set; }    //Qualified / Not Qualified / Pending
    public string Remarks { get; set; } //Comments or observations
}
