﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierQualificationCommandHandler(
    ISupplierQualificationRepository supplierQualificationRepository,
    ILogger<GetSupplierContactCommandHandler> _logger,
    IMapper mapper) : IRequestHandler<GetSupplierQualificationCommand, ServiceResponse<List<SupplierQualificationDto>>>
{
    public async Task<ServiceResponse<List<SupplierQualificationDto>>> Handle(GetSupplierQualificationCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await supplierQualificationRepository
                .All
                .Include(c => c.QualifiedBy)
                .Where(c => c.SupplierId == request.Id)
                .ToListAsync();
            var entitiesDto = mapper.Map<List<SupplierQualificationDto>>(entities);
            return ServiceResponse<List<SupplierQualificationDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting SupplierQualification");
            return ServiceResponse<List<SupplierQualificationDto>>.Return500("Error while getting SupplierQualification");
        }
    }
}