﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetTableSettingsQueryHandler(IMatTableSettingReposistory matTableSettingReposistory, IMapper mapper, UserInfoToken userInfoToken) : IRequestHandler<GetTableSettingsQuery, MatTableSettingDto>
    {
        public async Task<MatTableSettingDto> Handle(GetTableSettingsQuery request, CancellationToken cancellationToken)
        {
            var matTableSetting = await matTableSettingReposistory.All.Where(c => c.ScreenName == request.ScreenName && c.UserId == userInfoToken.Id).FirstOrDefaultAsync();

            if (matTableSetting == null)
            {
                return new MatTableSettingDto();
            }
            else
            {
                return mapper.Map<MatTableSettingDto>(matTableSetting);
            }
        }
    }
}
