﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllUserNotificationQueryHandler(
        IUserNotificationRepository _userNotificationRepository) : IRequestHandler<GetAllUserNotificationQuery, NotificationList>
    {
        public async Task<NotificationList> Handle(GetAllUserNotificationQuery request, CancellationToken cancellationToken)
        {
            return await _userNotificationRepository.GetUserNotifications(request.NotificationResource);
        }
    }
}
