﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAllUserOpenaiMsgCommandHandler(IUserOpenaiMsgRepository _userOpenaiMsgRepository) : IRequestHandler<GetAllUserOpenaiMsgCommand, UserOpenaiMsgList>
{
    public async Task<UserOpenaiMsgList> Handle(GetAllUserOpenaiMsgCommand request, CancellationToken cancellationToken)
    {
        return await _userOpenaiMsgRepository.GetUserOpenaiMsgAsync(request.userOpenaiMsgResource);
    }
}
