﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class DeleteUserCommandHandler(
    IUserRepository userRepository,
    IMapper mapper,
    UserInfoToken userInfoToken,
    ILogger<DeleteUserCommandHandler> logger,
    IUnitOfWork<QMSDbContext> _uow
    ) : IRequestHandler<DeleteUserCommand, ServiceResponse<UserDto>>
{
    public async Task<ServiceResponse<UserDto>> Handle(DeleteUserCommand request, CancellationToken cancellationToken)
    {
        var appUser = await userRepository.All.IgnoreQueryFilters().FirstOrDefaultAsync(c => c.Id == request.Id);
        if (appUser == null)
        {
            logger.LogError("User does not exist.");
            return ServiceResponse<UserDto>.Return409("User does not exist.");
        }

        appUser.IsActive = !appUser.IsActive;
        if (!appUser.IsActive)
        {
            appUser.DeletedDate = DateTime.UtcNow;
            appUser.DeletedBy = userInfoToken.Id;
        }
        else
        {
            appUser.DeletedDate = null;
            appUser.DeletedBy = null;
        }
        userRepository.Update(appUser);
        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<UserDto>.Return500();
        }
        return ServiceResponse<UserDto>.ReturnResultWith200(mapper.Map<UserDto>(appUser));
    }
}
