﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetUsersQueryHandler(
        IUserRepository _userRepository) : IRequestHandler<GetUsersQuery, UserList>
    {

        public async Task<UserList> Handle(GetUsersQuery request, CancellationToken cancellationToken)
        {
            var entities = await _userRepository.GetUsers(request.UserResource);
            return entities;
        }
    }
}
