﻿using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public record TokenByClientIdAndSecretCommandHandler(
      IUserRepository userRepository
            ) : IRequestHandler<TokenByClientIdAndSecretCommand, UserAuthDto>
{
    public async Task<UserAuthDto> Handle(TokenByClientIdAndSecretCommand request, CancellationToken cancellationToken)
    {
        var user = userRepository.All.Where(x => x.ClientId == request.ClientId && x.ClientSecretHash == request.ClientSecret).FirstOrDefault();
        if (user == null)
        {
            return new UserAuthDto
            {
                StatusCode = 401,
                Messages = new List<string> { "ClientId or ClientSecret is InCorrect." }
            };
        }
        var authUser = await userRepository.BuildUserAuthObject(user);
        return authUser;
    }
}

