﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteWorkflowInstanceCommandHandler(IUnitOfWork<QMSDbContext> _uow, IWorkflowInstanceRepository _workflowInstanceRepository) : IRequestHandler<DeleteWorkflowInstanceCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteWorkflowInstanceCommand request, CancellationToken cancellationToken)
        {
            var workflowInstance = await _workflowInstanceRepository.FindAsync(request.Id);
            if (workflowInstance == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            _workflowInstanceRepository.Delete(workflowInstance);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
    }
}