﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllWorkflowsInstanceCommandHandler(IWorkflowInstanceRepository _workflowInstanceRepository)
        : IRequestHandler<GetAllWorkflowsInstanceQuery, AllWorkflowInstanceList>
    {

        public async Task<AllWorkflowInstanceList> Handle(GetAllWorkflowsInstanceQuery request, CancellationToken cancellationToken)
        {
            return await _workflowInstanceRepository.GetWorkflowInstances(request.allWorkflowInstanceResource);
        }
    }
}