﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetWorkflowInstanceByWorkflowIdCommandHandler(IWorkflowInstanceRepository _workflowInstanceRepository) : IRequestHandler<GetWorkflowInstanceByWorkflowIdQuery, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(GetWorkflowInstanceByWorkflowIdQuery request, CancellationToken cancellationToken)
    {
        var entity = await _workflowInstanceRepository.All.FirstOrDefaultAsync(w => w.WorkflowId == request.WorkflowId);
        if (entity == null)
        {
            return ServiceResponse<bool>.Return409("Not found");
        }
        return ServiceResponse<bool>.ReturnResultWith200(true);
    }
}