﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetWorkflowInstanceCommandHandler(IWorkflowInstanceRepository _workflowInstanceRepository, IMapper _mapper) : IRequestHandler<GetWorkflowInstanceQuery, ServiceResponse<WorkflowInstanceDto>>
    {
        public async Task<ServiceResponse<WorkflowInstanceDto>> Handle(GetWorkflowInstanceQuery request, CancellationToken cancellationToken)
        {
            var entity = await _workflowInstanceRepository.All.FirstOrDefaultAsync(w => w.DocumentId == request.Id);
            if (entity == null)
            {
                return ServiceResponse<WorkflowInstanceDto>.Return409("Not found");
            }
            var result = _mapper.Map<WorkflowInstanceDto>(entity);
            return ServiceResponse<WorkflowInstanceDto>.ReturnResultWith200(result);
        }
    }
}