﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllWorkflowStepCommandHandler(IWorkflowStepRepository _workflowStepRepository, IMapper _mapper) : IRequestHandler<GetAllWorkflowStepQuery, ServiceResponse<List<WorkflowStepDto>>>
    {

        public async Task<ServiceResponse<List<WorkflowStepDto>>> Handle(GetAllWorkflowStepQuery request, CancellationToken cancellationToken)
        {
            var entities = await _workflowStepRepository.All.ToListAsync(cancellationToken);
            var dtos = _mapper.Map<List<WorkflowStepDto>>(entities);
            dtos.OrderBy(c => c.CreatedAt);
            return ServiceResponse<List<WorkflowStepDto>>.ReturnResultWith200(dtos);
        }
    }
}
