﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetWorkflowStepCommandHandler(IWorkflowStepRepository _workflowStepRepository, IMapper _mapper) : IRequestHandler<GetWorkflowStepQuery, ServiceResponse<WorkflowStepDto>>
    {
        public async Task<ServiceResponse<WorkflowStepDto>> Handle(GetWorkflowStepQuery request, CancellationToken cancellationToken)
        {
            var entity = await _workflowStepRepository
                .FindAsync(request.Id);

            if (entity == null)
            {
                return ServiceResponse<WorkflowStepDto>.Return409("Not found");
            }
            var result = _mapper.Map<WorkflowStepDto>(entity);
            return ServiceResponse<WorkflowStepDto>.ReturnResultWith200(result);
        }
    }
}
