﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.AspNetCore.SignalR;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteWorkflowTransitionCommandHandler(
        IUnitOfWork<QMSDbContext> _uow,
        IWorkflowTransitionRepository _workflowTransitionRepository,
         IHubContext<UserHub, IHubClient> hubContext,
             IConnectionMappingRepository connectionMappingRepository,
             UserInfoToken _userInfo) : IRequestHandler<DeleteWorkflowTransitionCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteWorkflowTransitionCommand request, CancellationToken cancellationToken)
        {
            var workflow = await _workflowTransitionRepository.FindAsync(request.Id);
            if (workflow == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            _workflowTransitionRepository.Remove(workflow);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            try
            {
                var user = connectionMappingRepository.GetUserInfoById(_userInfo.Id);

                if (user != null)
                {
                    await hubContext.Clients.AllExcept(new List<string> { user.ConnectionId }).RefreshWorkflowSettings();
                }
            }
            catch (Exception ex)
            {

            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
    }
}