﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetWorkflowTransitionCommandHandler(IWorkflowTransitionRepository _workflowTransitionRepository, IMapper _mapper) : IRequestHandler<GetWorkflowTransitionQuery, ServiceResponse<WorkflowTransitionDto>>
    {
        public async Task<ServiceResponse<WorkflowTransitionDto>> Handle(GetWorkflowTransitionQuery request, CancellationToken cancellationToken)
        {
            var entity = await _workflowTransitionRepository.FindAsync(request.Id);

            if (entity == null)
            {
                return ServiceResponse<WorkflowTransitionDto>.Return409("Not found");
            }
            var data = _mapper.Map<WorkflowTransitionDto>(entity);
            return ServiceResponse<WorkflowTransitionDto>.ReturnResultWith200(data);
        }
    }
}

