﻿using System.Linq;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;

namespace QualityManagement.Repository;
public class AuditResponseLogRepository(
    IPropertyMappingService _propertyMappingService,
    IUnitOfWork<QMSDbContext> _uow) : GenericRepository<AuditResponseLog, QMSDbContext>(_uow)
    , IAuditResponseLogRepository
{
    public async Task<AuditResponseLogList> GetAuditResponseLogs(AuditResponseResource auditResponseResource)
    {

        var collectionBeforePaging = AllIncluding(c => c.Audit, c => c.Question);

        collectionBeforePaging = collectionBeforePaging.ApplySort(auditResponseResource.OrderBy,
            _propertyMappingService.GetPropertyMapping<AuditResponseLogDto, AuditResponseLog>());

        if (!string.IsNullOrWhiteSpace(auditResponseResource.AuditTemplateName))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Audit.AuditTemplate.Name.StartsWith(auditResponseResource.AuditTemplateName));
        }
        if (!string.IsNullOrWhiteSpace(auditResponseResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Audit.Title.StartsWith(auditResponseResource.Title));
        }
        if (auditResponseResource.DepartmentId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Audit.AuditTemplate.DepartmentId == auditResponseResource.DepartmentId);
        }
        if (auditResponseResource.AuditorId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Audit.AuditorId == auditResponseResource.AuditorId);
        }
        if (auditResponseResource.auditStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Status == auditResponseResource.auditStatus);
        }
        if (auditResponseResource.auditType.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Audit.AuditTemplate.AuditType == auditResponseResource.auditType);
        }
        if (auditResponseResource.LogStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.LogStatus == auditResponseResource.LogStatus);
        }

        var allAuditResponseList = new AuditResponseLogList();
        return await allAuditResponseList.Create(
            collectionBeforePaging,
            auditResponseResource.Skip,
            auditResponseResource.PageSize);

    }
}