﻿using System;
using System.Linq;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;

namespace QualityManagement.Repository;
public class CapaRequestLogRepository(IUnitOfWork<QMSDbContext> _uow,
    IPropertyMappingService _propertyMappingService) : GenericRepository<CapaRequestLog, QMSDbContext>(_uow)
    , ICapaRequestLogRepository
{
    public async Task<CapaRequestLogList> GetCapaRequestLog(CapaRequestLogResource capaRequestLogResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.NonConformance, c => c.Audit, c => c.RaisedBY);

        collectionBeforePaging = collectionBeforePaging.ApplySort(capaRequestLogResource.OrderBy,
            _propertyMappingService.GetPropertyMapping<CapaRequestLogDto, CapaRequestLog>());

        if (!string.IsNullOrWhiteSpace(capaRequestLogResource.ReferenceNo))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.ReferenceNo.Contains(capaRequestLogResource.ReferenceNo));
        }
        if (!string.IsNullOrWhiteSpace(capaRequestLogResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Title.Contains(capaRequestLogResource.Title));
        }
        if (capaRequestLogResource.RaisedById.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.RaisedById == capaRequestLogResource.RaisedById);
        }
        if (capaRequestLogResource.AuditId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AuditId == capaRequestLogResource.AuditId);
        }
        if (capaRequestLogResource.NonConformanceId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.NonConformanceId == capaRequestLogResource.NonConformanceId);
        }
        if (capaRequestLogResource.LogStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.LogStatus == capaRequestLogResource.LogStatus);
        }
        if (capaRequestLogResource.Priority.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Priority == capaRequestLogResource.Priority);
        }
        if (capaRequestLogResource.CapaRequestStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.CapaRequestStatus == capaRequestLogResource.CapaRequestStatus);
        }
        if (capaRequestLogResource.DueStartDate.HasValue && capaRequestLogResource.DueEndDate.HasValue)
        {

            var startDate = capaRequestLogResource.DueStartDate.Value;
            var endDate = capaRequestLogResource.DueEndDate.Value;

            DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
            DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

            collectionBeforePaging = collectionBeforePaging
                        .Where(c => c.DueDate >= minDate &&
                            c.DueDate <= maxDate);
        }


        var capaRequestLogList = new CapaRequestLogList();
        return await capaRequestLogList.Create(
            collectionBeforePaging,
            capaRequestLogResource.Skip,
            capaRequestLogResource.PageSize);
    }
}
