﻿using System;
using System.Collections.Generic;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;

namespace QualityManagement.Repository;

public interface ICategoryRepository : IGenericRepository<Category>
{
    List<Guid> GetAllChildCategoryIdsUsingRawSql(Guid parentId);
    List<CategoryDto> GetAllDescendantsUsingCTE();
    List<CategoryDto> GetAllAssignedToMeDescendantsUsingCTE(Guid userId);
    List<CategoryDto> GetAllAssignedToMeSearchDropDownDescendantsUsingCTE(Guid userId);
    List<Category> GetAllChildrenAsync(Guid parentId);
    List<CategoryDto> GetAllDescendantsUsingCTEByParentId(Guid parentId);
}
