﻿using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository;
public class ComplaintLogRepository(IUnitOfWork<QMSDbContext> _uow, IPropertyMappingService _propertyMappingService) : GenericRepository<ComplaintLog, QMSDbContext>(_uow)
    , IComplaintLogRepository
{
    public async Task<ComplaintLogList> GetComplaintLog(ComplaintLogResource complaintLogResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.AssignedTo, c => c.ComplaintType);

        collectionBeforePaging = collectionBeforePaging.ApplySort(complaintLogResource.OrderBy,
       _propertyMappingService.GetPropertyMapping<ComplaintLogDto, ComplaintLog>());

        if (!string.IsNullOrWhiteSpace(complaintLogResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Title.Contains(complaintLogResource.Title));
        }
        if (!string.IsNullOrWhiteSpace(complaintLogResource.ComplaintNo))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.ComplaintNo.Contains(complaintLogResource.ComplaintNo));
        }
        if (!string.IsNullOrWhiteSpace(complaintLogResource.Description))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Description.Contains(complaintLogResource.Description));
        }
        if (!string.IsNullOrWhiteSpace(complaintLogResource.ResolutionSummary))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.ResolutionSummary.Contains(complaintLogResource.ResolutionSummary));
        }
        if (complaintLogResource.AssignedToId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AssignedToId == complaintLogResource.AssignedToId);
        }
        if (complaintLogResource.ComplaintTypeId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.ComplaintTypeId == complaintLogResource.ComplaintTypeId);
        }
        if (complaintLogResource.LogStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.LogStatus == complaintLogResource.LogStatus);
        }
        if (complaintLogResource.Priority.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Priority == complaintLogResource.Priority);
        }
        if (complaintLogResource.ReportedBy.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.ReportedBy == complaintLogResource.ReportedBy);
        }
        if (complaintLogResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Status == complaintLogResource.Status);
        }
        if (complaintLogResource.ComplaintStartDate.HasValue && complaintLogResource.ComplaintEndDate.HasValue)
        {
            var startDate = complaintLogResource.ComplaintStartDate.Value;
            var endDate = complaintLogResource.ComplaintEndDate.Value;

            DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
            DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

            collectionBeforePaging = collectionBeforePaging
                        .Where(c => c.ComplaintDate >= minDate &&
                            c.ComplaintDate <= maxDate);
        }
        var complaintLogList = new ComplaintLogList();
        return await complaintLogList.Create(
            collectionBeforePaging,
            complaintLogResource.Skip,
            complaintLogResource.PageSize);
    }
}