﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Data.Dto;

namespace QualityManagement.Repository;
public class CourseList : List<CourseDto>
{
    public CourseList()
    {
    }

    public int Skip { get; private set; }
    public int TotalPages { get; private set; }
    public int PageSize { get; private set; }
    public int TotalCount { get; private set; }

    public CourseList(List<CourseDto> items, int count, int skip, int pageSize)
    {
        TotalCount = count;
        PageSize = pageSize;
        Skip = skip;
        TotalPages = (int)Math.Ceiling(count / (double)pageSize);
        AddRange(items);
    }

    public async Task<CourseList> Create(IQueryable<Course> source, int skip, int pageSize)
    {
        var count = await GetCount(source);
        var dtoList = await GetDtos(source, skip, pageSize);
        var dtoPageList = new CourseList(dtoList, count, skip, pageSize);
        return dtoPageList;
    }

    public async Task<int> GetCount(IQueryable<Course> source)
    {
        return await source.AsNoTracking().CountAsync();
    }

    public async Task<List<CourseDto>> GetDtos(IQueryable<Course> source, int skip, int pageSize)
    {
        var entities = await source
            .Skip(skip)
            .Take(pageSize)
            .AsNoTracking()
            .Select(c => new CourseDto
            {
                Id = c.Id,
                CourseStatus = c.CourseStatus,
                Description = c.Description,
                AutoAssignToNewEmployee = c.AutoAssignToNewEmployee,
                Title = c.Title,
                CreatedDate = c.CreatedDate,
            })
            .ToListAsync();
        return entities;
    }
}