﻿
using QualityManagement.Common.GenericRepository;
using QualityManagement.Data;

namespace QualityManagement.Repository;

public interface ISendEmailRepository : IGenericRepository<SendEmail>
{
    void AddSharedEmails(SendEmail sendEmail, string documentName);
    void AddTransitionEmails(SendEmail sendEmail, string documentName, string transitionName, string workflowName);
    void AddFileRequestEmails(SendEmail sendEmail, string url);
    void AddFileRequestDocumentEmails(SendEmail sendEmail);
    void AddSharedFolderEmails(SendEmail sendEmail, string folderName);
    void AddAuditEmails(SendEmail sendEmail, string title);
    // For Any Qms Action Assignment
    void AddAsignmentEmails(SendEmail sendEmail, string title, string mainTitle, string subject);
}
