﻿using System.IO;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Domain;

namespace QualityManagement.Repository;

public class SendEmailRepository(
    IWebHostEnvironment _hostingEnvironment,
    IUnitOfWork<QMSDbContext> uow,
    IHttpContextAccessor _httpContextAccessor) : GenericRepository<SendEmail, QMSDbContext>(uow),
       ISendEmailRepository
{

    public void AddSharedEmails(SendEmail sendEmail, string documentName)
    {
        var requestContext = _httpContextAccessor.HttpContext.Request;
        var url = $"{requestContext.Scheme}://{requestContext.Host}";
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "SharedEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = $"{sendEmail.ToName} shared \"{documentName}\" with you";
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##FROM_NAME##", sendEmail.FromName)
            .Replace("##LINK##", url);
        Add(sendEmail);
    }

    public void AddSharedFolderEmails(SendEmail sendEmail, string folderName)
    {
        var requestContext = _httpContextAccessor.HttpContext.Request;
        var url = $"{requestContext.Scheme}://{requestContext.Host}";
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "SharedFolderEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = $"{sendEmail.ToName} shared \"{folderName}\" with you";
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##FROM_NAME##", sendEmail.FromName)
            .Replace("##LINK##", url);
        Add(sendEmail);
    }

    public void AddTransitionEmails(SendEmail sendEmail, string documentName, string transitionName, string workflowName)
    {
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "TransitionEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = $"You have been assigned the task of ${transitionName} the workflow ${workflowName} for the document named ${documentName}";
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##TRANSITION_NAME##", transitionName)
            .Replace("##WORKFLOW_NAME##", workflowName)
            .Replace("##DOCUMENT_NAME##", documentName);
        Add(sendEmail);
    }

    public void AddFileRequestEmails(SendEmail sendEmail, string url)
    {
        var requestContext = _httpContextAccessor.HttpContext.Request;
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "FileRequestEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = $"{sendEmail.ToName} has requested you to upload a file.";
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##FROM_NAME##", sendEmail.FromName)
            .Replace("##UPLOAD_LINK##", url);
        Add(sendEmail);
    }

    public void AddFileRequestDocumentEmails(SendEmail sendEmail)
    {
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "FileRequestDocumentEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = $"{sendEmail.ToName}  requested file has been successfully uploaded";
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName);
        Add(sendEmail);
    }

    public void AddAuditEmails(SendEmail sendEmail, string title)
    {
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "AuditEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = title;
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##FROM_NAME##", sendEmail.FromName)
            .Replace("##TITLE##", title);
        Add(sendEmail);

    }

    public void AddAsignmentEmails(SendEmail sendEmail, string message, string mainTitle, string subject)
    {
        var emailTemplatePath = Path.Combine(_hostingEnvironment.WebRootPath, "EmailTemplates", "AssignEmail.html");
        var emailTemplateContent = System.IO.File.ReadAllText(emailTemplatePath);
        sendEmail.Subject = subject;
        sendEmail.Message = emailTemplateContent
            .Replace("##TO_NAME##", sendEmail.ToName)
            .Replace("##FROM_NAME##", sendEmail.FromName)
            .Replace("##EMAIL_SUBJECT##", subject)
            .Replace("##EMAIL_BODY##", message)
            .Replace("##EMAIL_TITLE##", mainTitle);
        Add(sendEmail);

    }
}
