﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository;
public class EmployeeCourseRepository(
    IUnitOfWork<QMSDbContext> uow,
    IPropertyMappingService _propertyMappingService) : GenericRepository<EmployeeCourse, QMSDbContext>(uow), IEmployeeCourseRepository
{

    public async Task<AssignedEmployeeCourseList> GetAssignedEmployeesCourses(AssignedEmployeeCourseResource assignedEmployeeCourseResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.Course, d => d.Employee);

        collectionBeforePaging =
           collectionBeforePaging.ApplySort(assignedEmployeeCourseResource.OrderBy,
           _propertyMappingService.GetPropertyMapping<EmployeeCourseDto, EmployeeCourse>());

        if (assignedEmployeeCourseResource.UserId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                 .Where(s => s.EmployeeId == assignedEmployeeCourseResource.UserId);
        }
        if (assignedEmployeeCourseResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                 .Where(s => s.Status == assignedEmployeeCourseResource.Status);
        }
        if (assignedEmployeeCourseResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                 .Where(s => s.Status == assignedEmployeeCourseResource.Status);
        }

        if (assignedEmployeeCourseResource.CourseId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(s => s.CourseId == assignedEmployeeCourseResource.CourseId);
        }

        if (!string.IsNullOrWhiteSpace(assignedEmployeeCourseResource.CourseName))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c =>
               EF.Functions.Like(c.Course.Title, $"%{assignedEmployeeCourseResource.CourseName}%"));
        }
        if (!string.IsNullOrWhiteSpace(assignedEmployeeCourseResource.EmployeeName))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c =>
               EF.Functions.Like(c.Employee.FirstName, $"%{assignedEmployeeCourseResource.EmployeeName}%"));
        }

        var employees = new AssignedEmployeeCourseList();
        return await employees.Create(collectionBeforePaging,
            assignedEmployeeCourseResource.Skip,
            assignedEmployeeCourseResource.PageSize,
            assignedEmployeeCourseResource.OrderBy);
    }

    //TODO: improve logic
    //public async Task UpdateEmployeeCourseCompletedPercentageAsync(Guid employeeCourseId, Guid courseId)
    //{
    //    try
    //    {
    //        var courseSessions = await _context.CourseSessions
    //        .Where(cs => cs.CourseId == courseId)
    //        .Include(cs => cs.CourseSessionMedias)
    //        .ToListAsync();


    //        var sessions = await _context.EmployeeCourseSessions
    //           .Where(s => s.EmployeeCourseId == employeeCourseId && s.CourseSession.CourseId == courseId)
    //           .Include(s => s.EmployeeCourseSessionMedias)
    //           .ToListAsync();

    //        decimal totalPercentage = 0;

    //        foreach (var session in sessions)
    //        {
    //            var sessionMediaCount = courseSessions
    //                .FirstOrDefault(cs => cs.Id == session.CourseSessionId)?
    //                .CourseSessionMedias?.Count ?? 0;

    //            var readMedia = session.EmployeeCourseSessionMedias
    //                .Select(m => m.CourseSessionMediaId)
    //                .Distinct()
    //                .Count();

    //            var percent = sessionMediaCount == 0 ? 0 : Math.Round((decimal)(readMedia * 100.0 / sessionMediaCount), 2);

    //            totalPercentage += percent;

    //            await _context.EmployeeCourseSessions
    //                .Where(s => s.Id == session.Id)
    //                .ExecuteUpdateAsync(setters =>
    //                    setters.SetProperty(s => s.CompletedPercentage, percent));
    //        }

    //        var avg = Math.Round(totalPercentage / courseSessions.Count, 2);

    //        await _context.EmployeeCourses
    //            .Where(ec => ec.Id == employeeCourseId)
    //            .ExecuteUpdateAsync(setters =>
    //                setters.SetProperty(ec => ec.CompletedPercentage, avg));
    //    }
    //    catch (Exception ex)
    //    {
    //        Console.WriteLine($"{ex} error while save CompletePercentage");
    //    }

    //}
}
