﻿using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository;
public class NonConformanceLogRepository(IUnitOfWork<QMSDbContext> _uow,
    IPropertyMappingService _propertyMappingService) : GenericRepository<Data.Entities.NonConformanceLog, QMSDbContext>(_uow), INonConformanceLogRepository
{
    public async Task<NonConformanceLogList> GetNonConformanceLogs(NonConformanceLogResource nonConformanceLogResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.Department, c => c.ReportedBy);

        collectionBeforePaging = collectionBeforePaging.ApplySort(nonConformanceLogResource.OrderBy,
            _propertyMappingService.GetPropertyMapping<NonConformanceLogDto, NonConformanceLog>());

        if (!string.IsNullOrWhiteSpace(nonConformanceLogResource.NCNumber))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.NCNumber.Contains(nonConformanceLogResource.NCNumber));
        }
        if (nonConformanceLogResource.ReportedById.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.ReportedById == nonConformanceLogResource.ReportedById);
        }
        if (nonConformanceLogResource.AuditId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AuditId == nonConformanceLogResource.AuditId);
        }
        if (nonConformanceLogResource.DepartmentId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.DepartmentId == nonConformanceLogResource.DepartmentId);
        }
        if (nonConformanceLogResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Status == nonConformanceLogResource.Status);
        }
        if (nonConformanceLogResource.LogStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.LogStatus == nonConformanceLogResource.LogStatus);
        }
        if (nonConformanceLogResource.Severity.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Severity == nonConformanceLogResource.Severity);
        }

        var nonConformanceLogList = new NonConformanceLogList();
        return await nonConformanceLogList.Create(
            collectionBeforePaging,
            nonConformanceLogResource.Skip,
            nonConformanceLogResource.PageSize);
    }
}
