﻿using System;
using System.Linq;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;

namespace QualityManagement.Repository.RiskManagment;

public class RiskRepository(IUnitOfWork<QMSDbContext> _uow,
    IPropertyMappingService _propertyMappingService) : GenericRepository<Risk, QMSDbContext>(_uow), IRiskRepository
{
    public async Task<RiskList> GetRisk(RiskResource riskResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.AssignedTo, c => c.CreatedUser, c => c.RiskCategory);

        collectionBeforePaging = collectionBeforePaging.ApplySort(riskResource.OrderBy,
       _propertyMappingService.GetPropertyMapping<RiskDto, Risk>());

        if (!string.IsNullOrWhiteSpace(riskResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Title.Contains(riskResource.Title));
        }
        if (!string.IsNullOrWhiteSpace(riskResource.Description))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Description.Contains(riskResource.Description));
        }
        if (riskResource.RiskCategoryId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.RiskCategoryId == riskResource.RiskCategoryId);
        }
        if (riskResource.AssignedToId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AssignedToId == riskResource.AssignedToId);
        }
        if (riskResource.CreatedBy.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.CreatedBy == riskResource.CreatedBy);
        }
        if (riskResource.RiskScore.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.RiskScore == riskResource.RiskScore);
        }
        if (!string.IsNullOrWhiteSpace(riskResource.RiskLevel))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.RiskLevel == riskResource.RiskLevel);
        }
        if (riskResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Status == riskResource.Status);
        }
        if (riskResource.CreatedFromDate.HasValue && riskResource.CreatedToDate.HasValue)
        {
            //TODO
            var startDate = riskResource.CreatedFromDate.Value.ToLocalTime();
            var endDate = riskResource.CreatedToDate.Value.ToLocalTime();

            DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
            DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

            collectionBeforePaging = collectionBeforePaging
                        .Where(c => c.CreatedDate >= minDate &&
                            c.CreatedDate <= maxDate);
        }



        var riskList = new RiskList();
        return await riskList.Create(
            collectionBeforePaging,
            riskResource.Skip,
            riskResource.PageSize);


    }
}
