﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Domain;
using System;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading.Tasks;

namespace QualityManagement.Repository;

public class StorageSettingRepository(IUnitOfWork<QMSDbContext> uow) : GenericRepository<StorageSetting, QMSDbContext>(uow), IStorageSettingRepository
{

    public async Task<StorageSetting> GetStorageSettingByIdOrLocal(Guid? StorageId)
    {
        if (StorageId == Guid.Empty || StorageId == null)
        {
            return await All.Where(s => s.IsDefault || s.StorageType == StorageType.LOCAL_STORAGE).FirstOrDefaultAsync();
        }
        return await FindBy(s => s.Id == StorageId).FirstOrDefaultAsync();
    }
}
