﻿using QualityManagement.Common.GenericRepository;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace QualityManagement.Repository;

public interface IUserRepository : IGenericRepository<User>
{
    Task<UserAuthDto> BuildUserAuthObject(User appUser);

    Task<List<User>> GetUsersByIds(List<Guid> ids);
    Task<UserList> GetUsers(UserResource userResource);
    Task<List<Guid>> GetUsersByRoleId(Guid roleId);
    public Task<EmployeeCourseList> GetCourseEmployees(EmployeeResource employeeResource);
}
