﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;

namespace QualityManagement.Repository;

public class WorkflowTransitionRepository(IUnitOfWork<QMSDbContext> uow) : GenericRepository<WorkflowTransition, QMSDbContext>(uow), IWorkflowTransitionRepository
{
    public async Task<List<PendingTransition>> GetPendingTransitions(Guid currentStepId)
    {
        return await _uow.Context.PendingTransitions
            .FromSqlInterpolated($"CALL GetPendingWorkflowTransitions({currentStepId})")
            .ToListAsync();
    }
}
