﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Audit;

/// <summary>
/// Controller for AuditResponse
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class AuditResponseController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Add AuditResponse
    /// </summary>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPost]
    public async Task<IActionResult> AddAuditResponse(AddAuditResponseCommand command)
    {
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Update AuditResponse By id 
    /// </summary>
    /// <param name="id"></param>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPut("{id}")]
    public async Task<IActionResult> UpdateAuditResponse(Guid id, UpdateAuditResponseCommand command)
    {
        command.Id = id;
        var result = await _mediator.Send(command);
        return GenerateResponse(result);

    }
}
