﻿using System.Linq;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;


/// <summary>
/// Controller for AuditResponseLog
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class AuditResponseLogController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// get all Audit Response Log
    /// </summary>
    /// <param name="auditResponseResource"></param>
    /// <returns></returns>
    [HttpGet]
    [ClaimCheck("MANAGE_AUDIT_LOGS")]
    public async Task<IActionResult> GetAuditResponseLogs([FromQuery] AuditResponseResource auditResponseResource)
    {
        var getCapaRequestLogListCommand = new GetAuditResponseLogListCommand()
        {
            AuditResponseResource = auditResponseResource
        };
        var result = await _mediator.Send(getCapaRequestLogListCommand);
        var paginationMetadata = new
        {
            totalCount = result.TotalCount,
            pageSize = result.PageSize,
            skip = result.Skip,
            totalPages = result.TotalPages
        };
        Response.Headers.Append("X-Pagination",
            Newtonsoft.Json.JsonConvert.SerializeObject(paginationMetadata));

        return Ok(result);
    }
}

