﻿using System.Threading.Tasks;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Audit;
/// <summary>
/// Controller for AuditReviewer
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class AuditReviewerController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Add AuditReviewer
    /// </summary>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPost]
    public async Task<IActionResult> AddAuditReviewer(AddAuditReviewerCommand command)
    {
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }
}
