﻿using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Capa
{
    /// <summary>
    /// Controller for CapaRequsetLog
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class CapaRequsetLogController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// get all CapaRequest Log
        /// </summary>
        /// <param name="capaRequestLogResource"></param>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("MANAGE_CAPA_REQUEST_LOGS")]
        public async Task<IActionResult> GetCapaRequests([FromQuery] CapaRequestLogResource capaRequestLogResource)
        {
            var getCapaRequestLogListCommand = new GetCapaRequestLogListCommand()
            {
                CapaRequestLogResource = capaRequestLogResource
            };
            var result = await _mediator.Send(getCapaRequestLogListCommand);
            var paginationMetadata = new
            {
                totalCount = result.TotalCount,
                pageSize = result.PageSize,
                skip = result.Skip,
                totalPages = result.TotalPages
            };
            Response.Headers.Append("X-Pagination",
                Newtonsoft.Json.JsonConvert.SerializeObject(paginationMetadata));

            return Ok(result);
        }
    }
}
