﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Capa
{
    /// <summary>
    /// Controller for CapaReview
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class CapaReviewController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create a CapaReview
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_CAPA_REVIEW")]
        public async Task<IActionResult> AddCapaReview(AddCapaReviewCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Update a CapaReview by Id
        /// </summary>
        /// <param name="command"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("MANAGE_CAPA_REVIEW")]
        public async Task<IActionResult> UpdateCapaReview(Guid id, UpdateCapaReviewCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get all CapaReview by CapaRequest id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_CAPA_REVIEW")]
        public async Task<IActionResult> GetAllCapaReviewsByCapaRequestId(Guid id)
        {
            var result = await _mediator.Send(new GetCapaReviewCommand { Id = id });
            return GenerateResponse(result);
        }
    }
}
