﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Capa
{
    /// <summary>
    /// Controller for CapaRootCause
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class CapaRootCauseController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create a CapaRootCause 
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_CAPA_ROOT_CAUSE")]
        public async Task<IActionResult> CreateCapaRootCause(AddCapaRootCauseCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Update CapaRootCause by CapaRootCause id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("MANAGE_CAPA_ROOT_CAUSE")]
        public async Task<IActionResult> UpdateCapaRootCause(Guid id, UpdateCapaRootCauseCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Delete CapaRootCause by id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        public async Task<IActionResult> DeleteCapaRootCause(Guid id)
        {
            var result = await _mediator.Send(new DeleteCapaRootCauseCommand() { Id = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get all CapaRootCause by CapaRequest id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_CAPA_ROOT_CAUSE")]
        public async Task<IActionResult> GetCapaRootCause(Guid id)
        {
            var result = await _mediator.Send(new GetCapaRootCauseCommand() { CapaRequestId = id });
            return GenerateResponse(result);
        }
    }
}
