﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller For ComplaintAction
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintActionController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create A ComplaintAction
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_COMPLAINT_ACTION")]
        public async Task<IActionResult> CreateComplaintAction(AddComplaintActionCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get All ComplaintActions by Complaint id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        public async Task<IActionResult> GetAllComplaintActions(Guid id)
        {
            var result = await _mediator.Send(new GetAllComplaintActionCommand() { ComplaintId = id });
            return GenerateResponse(result);
        }
        /// <summary>
        ///Delete the ComplaintAction by Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_COMPLAINT_ACTION")]
        public async Task<IActionResult> DeleteComplaintAction(Guid id)
        {
            var command = new DeleteComplaintActionCommand() { Id = id };
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }
        /// <summary>
        /// Update A Complaint Action by Id
        /// </summary>
        /// <param name="command"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        public async Task<IActionResult> UpdateComplaintAction(Guid id, UpdateComplaintActionCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

    }
}
