﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Complaint
{
    /// <summary>
    /// Controller for ComplaintComment
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintCommentController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create A Complaint
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_COMPLAINT_COMMENT")]
        public async Task<IActionResult> CreateComplaintComment(AddComplaintCommentCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get All complaint Comment by Complaint id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_COMPLAINT_COMMENT")]
        public async Task<IActionResult> GetAllComplaintComent(Guid id)
        {
            var result = await _mediator.Send(new GetAllComplaintCommentCommand() { ComplaintId = id });
            return GenerateResponse(result);
        }

        /// <summary>
        ///Delete the ComplaintComment by Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_COMPLAINT_COMMENT")]
        public async Task<IActionResult> DeleteComplaintComment(Guid id)
        {
            var command = new DeleteComplaintCommentCommand() { Id = id };
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

    }
}
