﻿using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Complaint
{
    /// <summary>
    /// Controller for ComplaintLog
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintLogController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// get all Complaints Log
        /// </summary>
        /// <param name="complaintLogResource"></param>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("MANAGE_COMPLAINT_LOGS")]
        public async Task<IActionResult> GetCapaRequests([FromQuery] ComplaintLogResource complaintLogResource)
        {
            var getComplaintLogListCommand = new GetComplaintLogListCommand()
            {
                ComplaintLogResource = complaintLogResource
            };
            var result = await _mediator.Send(getComplaintLogListCommand);
            var paginationMetadata = new
            {
                totalCount = result.TotalCount,
                pageSize = result.PageSize,
                skip = result.Skip,
                totalPages = result.TotalPages
            };
            Response.Headers.Append("X-Pagination",
                Newtonsoft.Json.JsonConvert.SerializeObject(paginationMetadata));

            return Ok(result);
        }

    }
}
