﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller for ComplaintType
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintTypeController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// create A ComplaintType
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_COMPLAINT_TYPES")]
        public async Task<IActionResult> CreateComplainType(AddComplaintTypeCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);

        }

        /// <summary>
        /// Update ComplaintType by ComplaintType 
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("EDIT_COMPLAINT_TYPES")]
        public async Task<IActionResult> UpdateComplaintType(Guid id, UpdateComplaintTypeCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        ///Delete the ComplaintType by Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_COMPLAINT_TYPES")]
        public async Task<IActionResult> DeleteComplaintType(Guid id)
        {
            var command = new DeleteComplaintTypeCommand() { Id = id };
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get Complainttype by Complaint type id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        public async Task<IActionResult> GetComplaintType(Guid id)
        {
            var result = await _mediator.Send(new GetComplaintTypeCommand() { Id = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// get All the CapaRootCauseMethodology 
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("VIEW_COMPLAINT_TYPES")]
        public async Task<IActionResult> GetAllComplaintType()
        {
            var command = new GetAllComplaintsCommand();
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

    }
}
