﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller For Department
    /// </summary>
    /// <returns></returns>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class DepartmentController(IMediator mediator) : BaseController
    {
        /// <summary>
        /// Create A Department
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> CreateDepartment(AddDepartmentCommand command)
        {

            var result = await mediator.Send(command);
            return GenerateResponse(result);
        }
        /// <summary>
        /// Update A department by Department Id 
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        public async Task<IActionResult> UpdateDepartment(Guid id, UpdateDepartmentCommand command)
        {
            command.Id = id;
            var result = await mediator.Send(command);
            return GenerateResponse(result);
        }
        /// <summary>
        /// Delete Department By Department Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        public async Task<IActionResult> DeleteDepartment(Guid id)
        {
            var result = await mediator.Send(new DeleteDepartmentCommand { Id = id });
            return GenerateResponse(result);
        }
        /// <summary>
        /// Get All Department
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public async Task<IActionResult> GetAllDepartment()
        {
            var result = await mediator.Send(new GetAllDepartmentCommand());
            return Ok(result.Data);
        }
        /// <summary>
        /// Get A Department By Department Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        public async Task<IActionResult> GetDepartment(Guid id)
        {
            var result = await mediator.Send(new GetDepartmentCommand() { Id = id });
            return GenerateResponse(result);
        }
    }
}
