﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.DocumentPermission.User;

/// <summary>
/// DocumentUserPermission
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class DocumentUserPermissionController(IMediator _mediator) : ControllerBase
{
    /// <summary>
    /// Add Document User Permission
    /// </summary>
    /// <param name="addDocumentUserPermissionCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(DocumentUserPermissionDto))]
    [ClaimCheck("ALL_SHARE_DOCUMENT", "ASSIGNED_SHARE_DOCUMENT")]
    public async Task<IActionResult> AddDocumentUserPermission(AddDocumentUserPermissionCommand addDocumentUserPermissionCommand)
    {
        var result = await _mediator.Send(addDocumentUserPermissionCommand);
        return StatusCode(result.StatusCode, result);
    }
    /// <summary>
    /// Delete Document User Permission By Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("{Id}")]
    [ClaimCheck("ALL_SHARE_DOCUMENT", "ASSIGNED_SHARE_DOCUMENT")]
    public async Task<IActionResult> DeleteDocumentUserPermission(Guid Id)
    {
        var deleteUserPermissionCommand = new DeleteDocumentUserPermissionCommand
        {
            Id = Id
        };
        var result = await _mediator.Send(deleteUserPermissionCommand);
        return StatusCode(result.StatusCode, result);
    }

    /// <summary>
    /// Gets the reminder by documentId.
    /// </summary>
    /// <param name="documentId">The identifier.</param>
    /// <returns></returns>
    [HttpGet("{documentId}/check")]
    [Produces("application/json", "application/xml")]
    public async Task<IActionResult> CheckShareUserByDocumentId(Guid documentId)
    {
        var command = new CheckShareUserByDocumentCommand()
        {
            DocumentId = documentId
        };

        var result = await _mediator.Send(command);
        return Ok(result);
    }
}
