﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.DocumentToken
{
    /// <summary>
    /// Controller For Document Token
    /// </summary>
    /// <returns></returns>
    [Route("api/DocumentToken")]
    [ApiController]
    [Authorize]
    public class DocumenTokenController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Get Document by Token
        /// </summary>
        /// <param name="token"></param>
        /// <returns></returns>
        [HttpGet("token/{token}")]
        [AllowAnonymous]
        public async Task<ActionResult> GetDocumentByToken(Guid token)
        {
            var getDocumentTokenCommand = new GetDocumentTokenCommand
            {
                Token = token,
            };
            var result = await _mediator.Send(getDocumentTokenCommand);
            return Ok(result);
        }

        /// <summary>
        /// Gets the document token.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns></returns>
        [HttpGet("{id}/token")]
        [AllowAnonymous]
        public async Task<ActionResult> GetDocumentToken(Guid id)
        {
            var getDocumentTokenQuery = new GetDocumentTokenQuery
            {
                Id = id,
            };
            var result = await _mediator.Send(getDocumentTokenQuery);
            return Ok(new { result });
        }

        /// <summary>
        /// Add document
        /// </summary>
        /// <param name="addDocumentTokenCommand"></param>
        /// <returns></returns>
        [HttpPost("token")]
        public async Task<ActionResult> AddDocumentToken(AddDocumentTokenCommand addDocumentTokenCommand)
        {
            var result = await _mediator.Send(addDocumentTokenCommand);
            return Ok(new { result });
        }

        /// <summary>
        /// Deletes the document token.
        /// </summary>
        /// <param name="token"></param>
        /// <returns></returns>
        [HttpDelete("{token}")]
        public async Task<ActionResult> DeleteDocumentToken(Guid token)
        {
            var deleteDocumentTokenCommand = new DeleteDocumentTokenCommand { Token = token };
            var result = await _mediator.Send(deleteDocumentTokenCommand);
            return Ok(result);
        }

    }
}
