﻿using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Email;

/// <summary>
/// Controller For Email
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class EmailController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Send mail.
    /// </summary>
    /// <param name="sendEmailCommand"></param>
    /// <returns></returns>
    [HttpPost(Name = "SendEmail")]
    [Produces("application/json", "application/xml", Type = typeof(void))]
    [ClaimCheck("ALL_SEND_EMAIL")]
    public async Task<IActionResult> SendEmail(SendEmailCommand sendEmailCommand)
    {
        var result = await _mediator.Send(sendEmailCommand);
        return Ok(result);
    }
}
