﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.EmailTemplate;

/// <summary>
/// Controller For EmailTemplate
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
public class EmailTemplateController(IMediator _mediator, ILogger<EmailTemplateController> _logger) : BaseController
{
    /// <summary>
    /// Create  Email Template
    /// </summary>
    /// <param name="addEmailTemplateCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(EmailTemplateDto))]
    [ClaimCheck("email_template_add")]
    public async Task<IActionResult> AddEmailTemplate(AddEmailTemplateCommand addEmailTemplateCommand)
    {
        var result = await _mediator.Send(addEmailTemplateCommand);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Update Exist AppSetting By Id
    /// </summary>
    /// <param name="id"></param>
    /// <param name="updateEmailTemplateCommand"></param>
    /// <returns></returns>

    [HttpPut("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(EmailTemplateDto))]
    [ClaimCheck("email_template_edit")]
    public async Task<IActionResult> UpdateEmailTemplate(Guid id, UpdateEmailTemplateCommand updateEmailTemplateCommand)
    {
        updateEmailTemplateCommand.Id = id;
        var result = await _mediator.Send(updateEmailTemplateCommand);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Get Email Template By Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}", Name = "GetEmailTemplate")]
    [Produces("application/json", "application/xml", Type = typeof(EmailTemplateDto))]
    [ClaimCheck("email_template_edit")]
    public async Task<IActionResult> GetEmailTemplate(Guid id)
    {
        _logger.LogTrace("GetAppSetting");
        var getEmailTemplateQuery = new GetEmailTemplateQuery
        {
            Id = id
        };

        var result = await _mediator.Send(getEmailTemplateQuery);
        return GenerateResponse(result);

    }
    /// <summary>
    /// Get All Email Templates
    /// </summary>
    /// <returns></returns>
    [HttpGet(Name = "GetEmailTemplates")]
    [Produces("application/json", "application/xml", Type = typeof(List<EmailTemplateDto>))]
    [ClaimCheck("email_template_list")]
    public async Task<IActionResult> GetEmailTemplates()
    {
        var getAllEmailTemplateQuery = new GetAllEmailTemplateQuery
        {
        };
        var result = await _mediator.Send(getAllEmailTemplateQuery);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Delete Email Template By Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("{Id}")]
    [ClaimCheck("email_template_delete")]
    public async Task<IActionResult> DelterEmailTemplate(Guid Id)
    {
        var deleteEmailTemplateCommand = new DeleteEmailTemplateCommand
        {
            Id = Id
        };
        var result = await _mediator.Send(deleteEmailTemplateCommand);
        return GenerateResponse(result);
    }
}
