﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using QualityManagement.MediatR.EmployeeCoursesSessionMedias;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.EmployeeCourseSessionMedia
{

    /// <summary>
    /// Employee Course Session Media
    /// </summary>
    /// <param name="mediator"></param>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class EmployeeCourseSessionMediaController(IMediator mediator) : BaseController
    {
        /// <summary>
        /// marke employee course session media a read.
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [Produces("application/json", "application/xml", Type = typeof(void))]
        public async Task<IActionResult> MarkEmployeeCourseSessionMediaAsRead(MarkSessionMediaAsReadCommand command)
        {
            var result = await mediator.Send(command);
            return GenerateResponse(result);
        }

    }
}
